' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox. 
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com. 
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

''' <summary>
''' Klasa Faq reprezentuje najcziej zadawane pytanie na temat produktu.
''' Udostpnia waciwoci takie jak pytanie Question (krtk i dug wersj) oraz odpowied Answer.
''' </summary>
''' <remarks></remarks>
Public Class Faq

#Region "Zmienne prywatne"

  Private _id As Integer = -1
  Private _questionShort As String = String.Empty
  Private _questionLong As String = String.Empty
  Private _answer As String = String.Empty

#End Region

#Region "Konstruktor(y)"

  ''' <summary>
  ''' Konstruktor domylny.
  ''' </summary>
  Public Sub New()

  End Sub

  ''' <summary>
  ''' Tworzy nowy Faq i ustawia jego prywatny identyfikator. Uyteczny przy edycji Faq.
  ''' </summary>
  ''' <param name="id">Identyfikator Faq w bazie danych.</param>
  Public Sub New(ByVal id As Integer)
    _id = id
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Pobiera Faq z bazy danych wywoujc metod Get() klasy FaqDB.
  ''' </summary>
  Public Shared Function [Get](ByVal id As Integer) As Faq
    Return FaqDB.Get(id)
  End Function

  ''' <summary>
  ''' Zapisuje Faq w bazie danych wywoujc metod Save() klasy FaqDB.
  ''' </summary>
  Public Sub Save()
    FaqDB.Save(Me)
  End Sub

  ''' <summary>
  ''' Usuwa Faq z bazy danych wywoujc metod Delete() klasy FaqDB.
  ''' </summary>
  Public Shared Sub Delete(ByVal id As Integer)
    FaqDB.Delete(id)
  End Sub

  ''' <summary>
  ''' Pobiera list pozycji Faq pasujcych do szukanego terminu jako DataSet.
  ''' </summary>
  ''' <param name="searchTerm">Szukany termin, uywany do filtrowania listy Faq. Moe zawiera proste wyraenie jak "handheld 6800" lub logik boolowsk jak "Handyman OR 3100".</param>
  ''' <returns>A DataSet z danymi pozycjami Faq.</returns>
  Public Shared Function GetFaqList(ByVal searchTerm As String) As DataSet
    Return FaqDB.GetFaqList(searchTerm)
  End Function

  ''' <summary>
  ''' Pobiera list wszystkich pozycji Faq.
  ''' </summary>
  ''' <returns>DataSet z danymi pozycjami Faq.</returns>
  Public Shared Function GetFaqList() As DataSet
    Return FaqDB.GetFaqList()
  End Function

#End Region

#Region "Waciwoci publiczne"

  ''' <summary>
  ''' Zwraca identyfikator Faq w bazie danych.
  ''' </summary>
  Public ReadOnly Property Id() As Integer
    Get
      Return _id
    End Get
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia krtk wersj pytania Faq (np. tytu).
  ''' </summary>
  Public Property QuestionShort() As String
    Get
      Return _questionShort
    End Get
    Set(ByVal value As String)
      _questionShort = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia dug wersj pytania Faq.
  ''' </summary>
  Public Property QuestionLong() As String
    Get
      Return _questionLong
    End Get
    Set(ByVal value As String)
      _questionLong = value
    End Set
  End Property

  ''' <summary>
  ''' Pobiera lub ustawia odpowied na pytanie Faq.
  ''' </summary>
  Public Property Answer() As String
    Get
      Return _answer
    End Get
    Set(ByVal value As String)
      _answer = value
    End Set
  End Property

#End Region

End Class
